#!/bin/sh

#  -*- pse-c -*-
#----------------------------------------------------------------------------
# Filename: iegd_interface.c
# $Revision: 1.1.2.11 $
#----------------------------------------------------------------------------
# <>
# Copyright © 2006, Intel Corporation.
#
# This program is free software; you can redistribute it and/or modify it
# under the terms and conditions of the GNU General Public License,
# version 2, as published by the Free Software Foundation.
#
# This program is distributed in the hope it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
# more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc., 
# 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
#
#
#----------------------------------------------------------------------------
#

KERNELDIR=/lib/modules/$(uname -r)
BUILDDIR=$KERNELDIR/build
INSTALLDIR=$KERNELDIR/kernel/drivers/char/agp
MAKEFILE="Makefile"
DEPMOD=$(whereis depmod | awk '{print $2}')

# Function to create makefile.
create_make_file()
{
cat > $MAKEFILE <<'IEGDMAKEFILE'
KERNELVER ?= $(shell uname -r)
KERNELDIR ?= /lib/modules/$(KERNELVER)/build
INSTALLDIR ?= installdir
PWD ?= $(shell pwd)

CFLAGS += -I$(PWD)/include
CFLAGS += -I$(PWD)/val/agp/agpversion -I$(PWD)/val/drm/drmversion -DRM_FLAG_DEBUG

all: clean modules

modules:
		@echo $(PWD)
		@$(MAKE) -C $(KERNELDIR) M=$(PWD) modules

install:
		install -o root -g root -m 755 -d $(INSTALLDIR)
		install -o root -g root -m 744 iegd_mod.ko $(INSTALLDIR)
		/sbin/depmod -a

uninstall:
		rm -rf $(INSTALLDIR)/iegd_mod.ko
		/sbin/depmod -a

clean:
		@rm -f *.o iegd*.ko iegd*.mod.c iegd*.o agp/*.o drm/*.o Module.symvers
		@rm -fr .intel* .tmp* .*.cmd agp/.*.cmd drm/.*.cmd

obj-m := iegd_mod.o
iegd_mod-objs := agp/pci.o agp/global.o agp/drv_alm.o agp/drv_nap.o agp/drv_cmn.o agp/drv_gn4.o drm/iegd_drv.o drm/iegd_interface.o drm/iegd_interface_265.o drm/iegd_interface_2611.o drm/iegd_interface_2615.o

IEGDMAKEFILE
}

# Function to uninstall IKM
uninstall_iegd_mod()
{
	if [ ! -f $MAKEFILE ]
	then
		create_make_file
	fi

	echo -e "\n\nUninstalling IEGD kernel module"

	if [[ ! -w "$INSTALLDIR" && $(id -u) -ne 0 ]]
	then
		echo -e "\n\033[1m$INSTALLDIR is not accessible"
		while [[ "$answer" != "Y" || "$answer" != "y" || "$answer" != "N" || "$answer" != "n" ]]
		do
			echo -ne "\033[51mSwitch to user root? [y/n] \033[0m"
			read answer
			case "$answer" in

				"Y" | "y")

				su -c "make -f $MAKEFILE uninstall"

				if [ "$?" -ne "0" ]
				then
					continue
				else
					break
				fi
				;;

				"N" | "n")
				echo "Uninstallation process of IKM is been cancelled"
				exit 1
				;;

				*)
				echo "Invalid option... Try again?"
				continue
				;;

			esac
		done
	else
		make -f $MAKEFILE uninstall
	fi
	
	echo "Uninstallation complete"
}

argument=$(echo $1 | tr [A-Z] [a-z])

if [ "$argument" = "uninstall" ]
then
	uninstall_iegd_mod
	exit
fi

if [ ! -d "$BUILDDIR" ]
then
	echo "Kernel-devel required in order to compile kernel module"
	exit
fi

if [ ! -f $BUILDDIR/include/linux/config.h ]
then
	echo "Creating config.h file"
	touch $BUILDDIR/include/linux/config.h
fi

kernelver=$(uname -r)
fc5string=2.6.15-1.2054_FC5
release_ver=$(echo $kernelver | awk -F. '{print $1 $2 $3}' | awk -F- '{print $1}')

echo "release_ver $release_ver"

#Detecting agp release version
if [ "$release_ver" -le "2611" ]
then
	agpversion="agpm0v100"
elif [ "$release_ver" -le "2620" ]
then
	agpversion="agpm0v101"
elif [ "$release_ver" -ge "2621" ]
then
	agpversion="agpm0v102"
else
	echo "Unknown kernel version. Please check agp version, and select proper path above"
	exit 1;
fi

#Detecting DRM version
if [[ "$release_ver" -le "2610" ]]
then
	drmversion="drmv00p0"
elif [[ "$release_ver" -ge "2611" && "$release_ver" -le "2615" ]]
then
	# FC5 drm version is not taily with the vanilla kernel version
	status=$(expr match "$kernelver" "$fc5string") 
	if [ "$status" -ne 0 ]
	then
		drmversion="drmv10p1"
	else
		drmversion="drmv10p0"
	fi

elif [[ "$release_ver" -ge "2616" && "$release_ver" -le "2619" ]]
then
	drmversion="drmv10p1"
elif [[ "$release_ver" -ge "2620" ]]
then
	drmversion="drmv11p0"
else
	echo "Unknown kernel version. Please check drm version, and select proper path above"
	exit 1;
fi

echo "agpversion $agpversion"
echo "drmversion $drmversion"

# Call routine to create makefile
create_make_file

if [ -f "$MAKEFILE" ]
then
	sed -i "s/agpversion/$agpversion/g" $MAKEFILE
	sed -i "s/drmversion/$drmversion/g" $MAKEFILE
	sed -i "s|installdir|$INSTALLDIR|g" $MAKEFILE
else
	echo "Makefile creation error"
	exit 1
fi

if ! make -f $MAKEFILE
then
	echo "Make error:"
	exit 1
fi


echo -e "\n\nThis will install the module to the $INSTALLDIR. "

if [[ ! -w "$INSTALLDIR" && $(id -u) -ne 0 ]]
then
	echo -e "\n\n\033[1m$INSTALLDIR is not accessible"
	while [[ "$answer" != "Y" || "$answer" != "y" || "$answer" != "N" || "$answer" != "n" ]]
	do
		echo -ne "\033[51mSwitch to user root? [y/n] \033[0m"
		read answer
		case "$answer" in

			"Y" | "y")

			su -c "make -f $MAKEFILE install"

			if [ "$?" -ne "0" ]
			then
				continue
			else
				break
			fi
			;;

			"N" | "n")
			echo "iegd_mod.ko is not copy to $INSTALLDIR"
			exit 1
			;;

			*)
			echo "Invalid option... Try again?"
			continue
			;;

		esac
	done
else
	msg="Is this ok? [y/n]"

	while [[ "$answer" != "Y" || "$answer" != "y" || "$answer" != "N" || "$answer" != "n" ]]
	do
		echo -ne "\033[51m$msg \033[0m"
		read answer
		case "$answer" in

			"Y" | "y")

			su -c "make -f $MAKEFILE install"

			if [ "$?" -ne "0" ]
			then
				continue
			else
				break
			fi
			;;

			"N" | "n")
			echo "iegd_mod.ko is not copy to $INSTALLDIR"
			exit 1
			;;

			*)
			msg="Invalid option... Try again?[y/n]"
			continue
			;;

		esac
	done
fi

echo "Installation complete"

